using System;
using System.Threading;

using DarkStride.StellarLanes.SharedDLL;
using DarkStrideToolbox;


namespace DarkStride.StellarLanes.Client
{
	[Serializable]
	public class DSFileDownloadCompletedEventArgs : EventArgs 
	{
		#region Properties
		private bool m_bSuccessful = false;
        private System.Exception m_oError = null;
		#endregion

        public DSFileDownloadCompletedEventArgs(bool bSuccessful, System.Exception oError )
		{
			m_bSuccessful = bSuccessful;
            m_oError = oError;
		}

		#region Properties
		public bool Successful
		{
			get
			{
				return( m_bSuccessful );
			}
			set
			{
				m_bSuccessful = value;
			}
		}
        public System.Exception Error
        {
            get
            {
                return (m_oError);
            }
            set
            {
                m_oError = value;
            }
        }
		#endregion
	}
	[Serializable]
	public class DSFileDownloadProgresEventArgs : EventArgs 
	{
		#region Properties
		private string m_sCurFile = "";
		private int m_nFileIndex = 0;
		private int m_nNumberOfFiles = 0;
		private double m_nFileProgress = 0;
		private double m_nTotalProgress = 0;
		#endregion

		public DSFileDownloadProgresEventArgs( string sCurFile,int nFileIndex,int nNumberOfFiles,double nFileProgress,double nTotalProgress )
		{
			m_sCurFile = sCurFile;
			m_nFileIndex = nFileIndex;
			m_nNumberOfFiles = nNumberOfFiles;
			m_nFileProgress = nFileProgress;
			m_nTotalProgress = nTotalProgress;
		}

		#region Properties
		public string CurFile
		{
			get
			{
				return( m_sCurFile );
			}
			set
			{
				m_sCurFile = value;
			}
		}
		public int FileIndex
		{
			get
			{
				return( m_nFileIndex );
			}
			set
			{
				m_nFileIndex = value;
			}
		}
		public int NumberOfFiles
		{
			get
			{
				return( m_nNumberOfFiles );
			}
			set
			{
				m_nNumberOfFiles = value;
			}
		}
		public double FileProgress
		{
			get
			{
				return( m_nFileProgress );
			}
			set
			{
				m_nFileProgress = value;
			}
		}
		public double TotalProgress
		{
			get
			{
				return( m_nTotalProgress );
			}
			set
			{
				m_nTotalProgress = value;
			}
		}
		#endregion
	}


	public class FileDownloader
	{
		#region Properties
		private bool m_bDownloadingSuccessful = false;
		private bool m_bDownloading = false;
		private double m_nCurrentFileProgress = 0;

		private const string m_cDWNLDTEXT = ".dwnlded";
		private DSFileClient m_oFileClient = null;
		private string[] m_saFilesNeedingDownloading = null;
		private System.Threading.Thread m_oDownloadLoop = null;

		public event EventHandler FileTransferProgress;
		public event EventHandler FileTransferComplete;

		protected void RaiseFileTransferProgressEvent( string sCurFile,int nFileIndex,int nNumberOfFiles,double nFileProgress,double nTotalProgress )
		{
			DSFileDownloadProgresEventArgs oArgs = null;

			if( FileTransferProgress != null )
			{
				oArgs = new DSFileDownloadProgresEventArgs( sCurFile,nFileIndex,nNumberOfFiles,nFileProgress,nTotalProgress );
				FileTransferProgress( null, oArgs );
			}
		}
		protected void RaiseFileTransferCompleteEvent( bool bSuccessful,System.Exception oEx )
		{
            DSFileDownloadCompletedEventArgs oArgs = new DSFileDownloadCompletedEventArgs(bSuccessful, oEx);

			if( FileTransferComplete != null )
			{
				FileTransferComplete( null,oArgs );
			}
		}
		#endregion Properties
 

		public FileDownloader()
		{
		}
		public void DownloadFiles( string[] saFilesNeedingDownloading )
		{
			m_saFilesNeedingDownloading = saFilesNeedingDownloading;

			m_oFileClient = new DSFileClient();			
			m_oFileClient.FileTransferUpdate += new EventHandler( this.TransferUpdate );
			m_oFileClient.FileTransferCompleted += new EventHandler( this.TransferCompleted );

			m_oDownloadLoop = new Thread( new ThreadStart( this.FileDownloadLoop ) );
			m_oDownloadLoop.IsBackground = true;
			m_oDownloadLoop.Start();
		}
		private void FileDownloadLoop()
		{
			string sIP = "";
			string sDest = "";
			long nPort = 0;
			double nTotalProgress = 0;
			DSGobTable oGobTable = null;


			try
			{
				//Get the IP to download from
				oGobTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SETTINGS );
				sIP = (string)oGobTable.FindValue( 0,GobConstants.m_cSETTING_FILESERVERIP );
				nPort = (long)oGobTable.FindValue( 0,GobConstants.m_cSETTING_FILESERVERPORT );

				m_oFileClient.ConnectToFileServer( sIP,nPort );

				//Walk through all the files needing udpates and download them
				for( int i=0 ; i<m_saFilesNeedingDownloading.Length ; i++ )
				{
					m_bDownloading = true;
					sDest = Environment.CurrentDirectory + @"\" + System.IO.Path.GetFileName( m_saFilesNeedingDownloading[ i ] ) + m_cDWNLDTEXT;
					m_oFileClient.StartFileTransfer( System.IO.Path.GetFileName( m_saFilesNeedingDownloading[ i ] ),sDest );

					while( m_bDownloading == true )
					{
						//Calculate the progress of the entire download
						nTotalProgress = ( i + m_nCurrentFileProgress ) / m_saFilesNeedingDownloading.Length;
						RaiseFileTransferProgressEvent( m_saFilesNeedingDownloading[ i ],
							i+1,m_saFilesNeedingDownloading.Length,m_nCurrentFileProgress,
							nTotalProgress );
					} 
				}
  
				//Send a final message
				m_bDownloadingSuccessful = true;
				RaiseFileTransferCompleteEvent( true,null );
			}
			catch( System.Exception oEx )
			{
				RaiseFileTransferCompleteEvent( false,oEx );
				//DSMisc.ShowErrors( oEx );
			}
		}

		public void ReplaceExecutables( bool bLaunchWhenDone )
		{
			string sCmd = "";
			string sArgs = "";
            string sFromFile = string.Empty, sToFile = string.Empty;


			sCmd = "\"" + Environment.CurrentDirectory + "\\Recoil.EXE\"";

			for( int i=0 ; i<m_saFilesNeedingDownloading.Length ; i++ )
			{
                sFromFile = Environment.CurrentDirectory + @"\" +
                            System.IO.Path.GetFileName(m_saFilesNeedingDownloading[i]) + m_cDWNLDTEXT;
                sToFile = Environment.CurrentDirectory + @"\" +
                          System.IO.Path.GetFileName(m_saFilesNeedingDownloading[i]);

                if (System.IO.Path.GetFileName(m_saFilesNeedingDownloading[i]).ToUpper() == "RECOIL.EXE")
                {
                    //Recoil is special, just copy it over the old one right away
                    System.IO.File.Copy(sFromFile, sToFile,true );
                    System.IO.File.Delete(sFromFile);
                }
                else
                {
                    sArgs += "\"" + sToFile + "\" \"" + sFromFile + "\" ";
                }
			}
			//Don't make backups
			//sArgs += " /b /d ";
			sArgs += " /d ";
			
			if( bLaunchWhenDone == true )
			{
				sArgs += "/l:" + Environment.CommandLine + " ";
			}
			System.Diagnostics.Process.Start( sCmd,sArgs );
		}

		private void TransferUpdate( object sender, System.EventArgs e )
		{
			DSFileTransferEventArgs oArgs = (DSFileTransferEventArgs)e;
			m_nCurrentFileProgress = oArgs.Progress;
		}
		private void TransferCompleted( object sender, System.EventArgs e )
		{
			DSFileTransferEventArgs oArgs = (DSFileTransferEventArgs)e;
			m_nCurrentFileProgress = 1;
			m_bDownloading = false;
		}


		#region Properties
		public bool DownloadingSuccessful
		{
			get
			{
				return( m_bDownloadingSuccessful );
			}
			set
			{
				m_bDownloadingSuccessful = value;
			}
		}
		#endregion
	}
}
